export function apply_responsive(props, key, selector, css_prop_key = 'padding', important = false) {
    let additionalCss = [];
    if (!props[key]) {
        return;
    }
    let importantValue = important ? '!important' : '';
    let desktop = props[key];
    const isLastEdit = props["".concat(key + "_last_edited")];
    const statusActive = isLastEdit && isLastEdit.startsWith("on");

    switch (css_prop_key) {
        case 'padding':
        case 'margin' :

            desktop = !["padding", "margin"].includes(css_prop_key) ? props[key] : props[key].split("|");

            additionalCss.push([{
                selector,
                declaration: !["padding", "margin"].includes(css_prop_key) ? `${css_prop_key}: ${desktop} ${importantValue};` : `${css_prop_key}-top: ${desktop[0]} ${importantValue}; ${css_prop_key}-right: ${desktop[1]} ${importantValue}; ${css_prop_key}-bottom: ${desktop[2]} ${importantValue}; ${css_prop_key}-left: ${desktop[3]} ${importantValue};`,
            }]);

            if (props["".concat(key + "_tablet")] && statusActive) {
                const tablet = !["padding", "margin"].includes(css_prop_key) ? props[key] : props["".concat(key + "_tablet")].split("|");
                additionalCss.push([{
                    selector,
                    declaration: !["padding", "margin"].includes(css_prop_key) ? `${css_prop_key}: ${tablet} ${importantValue};` : `${css_prop_key}-top: ${tablet[0]} ${importantValue}; ${css_prop_key}-right: ${tablet[1]} ${importantValue}; ${css_prop_key}-bottom: ${tablet[2]} ${importantValue}; ${css_prop_key}-left: ${tablet[3]} ${importantValue};`,
                    'device': 'tablet',
                }]);
            }
            if (props["".concat(key + "_phone")] && statusActive) {
                const phone = !["padding", "margin"].includes(css_prop_key) ? props[key] : props["".concat(key + "_phone")].split("|");
                additionalCss.push([{
                    selector,
                    declaration: !["padding", "margin"].includes(css_prop_key) ? `${css_prop_key}: ${phone} ${importantValue};` : `${css_prop_key}-top: ${phone[0]} ${importantValue}; ${css_prop_key}-right: ${phone[1]} ${importantValue}; ${css_prop_key}-bottom: ${phone[2]} ${importantValue}; ${css_prop_key}-left: ${phone[3]} ${importantValue};`,
                    'device': 'phone',
                }]);
            }
            return additionalCss;

        default:
            additionalCss.push([{
                selector,
                declaration: css_prop_key + ':' + props[key] + importantValue,
            }]);

            if (props["".concat(key + "_tablet")] && statusActive) {
                additionalCss.push([{
                    selector,
                    declaration: css_prop_key + ':' + props[key + "_tablet"] + importantValue,
                    device: 'tablet'
                }]);
            }
            if (props["".concat(key + "_phone")] && statusActive) {
                additionalCss.push([{
                    selector,
                    declaration: css_prop_key + ':' + props[key + "_phone"] + importantValue,
                    device: 'phone'
                }]);
            }
            return additionalCss;
    }

};
